from django import forms
import re

class ContactForm(forms.Form):
    first_name = forms.CharField(
        max_length=60,
        required=True,
        label="Your good name",
        error_messages={
            'required': 'Please enter your good name.',
            'max_length': 'Your good name cannot exceed 60 characters.',
        },
        widget=forms.TextInput(attrs={
            'placeholder': 'Your good name',
            'class': 'form-control'
        })
    )

    LOOKING_FOR_CHOICES = [
        ('', 'Select an option'),
        ('Hardware', 'Hardware'),
        ('Software', 'Software'),
        ('Services', 'Services'),
    ]
    looking_for = forms.ChoiceField(
        choices=LOOKING_FOR_CHOICES,
        required=True,
        label="Looking For",
        error_messages={
            'required': 'Please select what you are looking for.',
        },
        widget=forms.Select(attrs={'class': 'form-select',})
    )

    email = forms.EmailField(
        required=True,
        label="Email",
        error_messages={
            'required': 'Please enter your email address.',
            'invalid': 'Enter a valid email address.',
        },
        widget=forms.EmailInput(attrs={
            'placeholder': 'Email Address',
            'class': 'form-control',
            # "data-clarity-unmask": "true",
            # "data-clarity-privacy": "unmasked"
        })
    )

    COUNTRY_CODE_CHOICES = [ ('+', 'Select your country code'),('+61', '+61 (Australia)'), ('+93', '+93 (Afghanistan)'),
        ('+355', '+355 (Albania)'),
        ('+213', '+213 (Algeria)'),
        ('+376', '+376 (Andorra)'),
        ('+244', '+244 (Angola)'),
        ('+54', '+54 (Argentina)'),
        ('+374', '+374 (Armenia)'),
        ('+61', '+61 (Australia)'),
        ('+43', '+43 (Austria)'),
        ('+994', '+994 (Azerbaijan)'),
        ('+1-242', '+1-242 (Bahamas)'),
        ('+973', '+973 (Bahrain)'),
        ('+880', '+880 (Bangladesh)'),
        ('+1-246', '+1-246 (Barbados)'),
        ('+375', '+375 (Belarus)'),
        ('+32', '+32 (Belgium)'),
        ('+501', '+501 (Belize)'),
        ('+229', '+229 (Benin)'),
        ('+975', '+975 (Bhutan)'),
        ('+591', '+591 (Bolivia)'),
        ('+387', '+387 (Bosnia and Herzegovina)'),
        ('+267', '+267 (Botswana)'),
        ('+55', '+55 (Brazil)'),
        ('+673', '+673 (Brunei)'),
        ('+359', '+359 (Bulgaria)'),
        ('+226', '+226 (Burkina Faso)'),
        ('+257', '+257 (Burundi)'),
        ('+855', '+855 (Cambodia)'),
        ('+237', '+237 (Cameroon)'),
        ('+1', '+1 (Canada)'),
        ('+238', '+238 (Cape Verde)'),
        ('+236', '+236 (Central African Republic)'),
        ('+235', '+235 (Chad)'),
        ('+56', '+56 (Chile)'),
        ('+86', '+86 (China)'),
        ('+57', '+57 (Colombia)'),
        ('+269', '+269 (Comoros)'),
        ('+506', '+506 (Costa Rica)'),
        ('+385', '+385 (Croatia)'),
        ('+53', '+53 (Cuba)'),
        ('+357', '+357 (Cyprus)'),
        ('+420', '+420 (Czech Republic)'),
         ('+45', '+45 (Denmark)'),
        ('+253', '+253 (Djibouti)'),
        ('+1-767', '+1-767 (Dominica)'),
        ('+1-809', '+1-809 (Dominican Republic)'),
        ('+593', '+593 (Ecuador)'),
        ('+20', '+20 (Egypt)'),
        ('+503', '+503 (El Salvador)'),
        ('+240', '+240 (Equatorial Guinea)'),
        ('+291', '+291 (Eritrea)'),
        ('+372', '+372 (Estonia)'),
        ('+268', '+268 (Eswatini)'),
        ('+251', '+251 (Ethiopia)'),
        ('+679', '+679 (Fiji)'),
        ('+358', '+358 (Finland)'),
        ('+33', '+33 (France)'),
        ('+241', '+241 (Gabon)'),
        ('+220', '+220 (Gambia)'),
        ('+995', '+995 (Georgia)'),
        ('+49', '+49 (Germany)'),
        ('+233', '+233 (Ghana)'),
        ('+30', '+30 (Greece)'),
        ('+1-473', '+1-473 (Grenada)'),
        ('+502', '+502 (Guatemala)'),
        ('+224', '+224 (Guinea)'),
        ('+592', '+592 (Guyana)'),
        ('+509', '+509 (Haiti)'),
        ('+504', '+504 (Honduras)'),
        ('+36', '+36 (Hungary)'),
        ('+354', '+354 (Iceland)'),
        ('+91', '+91 (India)'),
        ('+62', '+62 (Indonesia)'),
        ('+98', '+98 (Iran)'),
        ('+964', '+964 (Iraq)'),
        ('+353', '+353 (Ireland)'),
        ('+972', '+972 (Israel)'),
        ('+39', '+39 (Italy)'),
        ('+225', '+225 (Ivory Coast)'),
        ('+1-876', '+1-876 (Jamaica)'),
        ('+81', '+81 (Japan)'),
        ('+962', '+962 (Jordan)'),
        ('+7', '+7 (Kazakhstan)'),
        ('+254', '+254 (Kenya)'),
        ('+686', '+686 (Kiribati)'),
        ('+965', '+965 (Kuwait)'),
        ('+996', '+996 (Kyrgyzstan)'),
        ('+856', '+856 (Laos)'),
        ('+371', '+371 (Latvia)'),
        ('+961', '+961 (Lebanon)'),
        ('+266', '+266 (Lesotho)'),
        ('+231', '+231 (Liberia)'),
        ('+218', '+218 (Libya)'),
        ('+423', '+423 (Liechtenstein)'),
        ('+370', '+370 (Lithuania)'),
        ('+352', '+352 (Luxembourg)'),
        ('+261', '+261 (Madagascar)'),
        ('+265', '+265 (Malawi)'),
        ('+60', '+60 (Malaysia)'),
        ('+960', '+960 (Maldives)'),
        ('+223', '+223 (Mali)'),
        ('+356', '+356 (Malta)'),
        ('+692', '+692 (Marshall Islands)'),
        ('+222', '+222 (Mauritania)'),
        ('+230', '+230 (Mauritius)'),
        ('+52', '+52 (Mexico)'),
        ('+691', '+691 (Micronesia)'),
        ('+373', '+373 (Moldova)'),
        ('+377', '+377 (Monaco)'),
        ('+976', '+976 (Mongolia)'),
        ('+382', '+382 (Montenegro)'),
        ('+212', '+212 (Morocco)'),
        ('+258', '+258 (Mozambique)'),
        ('+95', '+95 (Myanmar)'),
        ('+264', '+264 (Namibia)'),
        ('+674', '+674 (Nauru)'),
        ('+977', '+977 (Nepal)'),
        ('+31', '+31 (Netherlands)'),
        ('+64', '+64 (New Zealand)'),
        ('+505', '+505 (Nicaragua)'),
        ('+227', '+227 (Niger)'),
        ('+234', '+234 (Nigeria)'),
        ('+850', '+850 (North Korea)'),
        ('+389', '+389 (North Macedonia)'),
        ('+47', '+47 (Norway)'),
        ('+968', '+968 (Oman)'),
        ('+92', '+92 (Pakistan)'),
        ('+680', '+680 (Palau)'),
        ('+507', '+507 (Panama)'),
        ('+675', '+675 (Papua New Guinea)'),
        ('+595', '+595 (Paraguay)'),
        ('+51', '+51 (Peru)'),
        ('+63', '+63 (Philippines)'),
        ('+48', '+48 (Poland)'),
        ('+351', '+351 (Portugal)'),
        ('+974', '+974 (Qatar)'),
        ('+242', '+242 (Republic of the Congo)'),
        ('+40', '+40 (Romania)'),
        ('+7', '+7 (Russia)'),
        ('+250', '+250 (Rwanda)'),
        ('+1-869', '+1-869 (Saint Kitts and Nevis)'),
        ('+1-758', '+1-758 (Saint Lucia)'),
        ('+1-784', '+1-784 (Saint Vincent and the Grenadines)'),
        ('+685', '+685 (Samoa)'),
        ('+378', '+378 (San Marino)'),
        ('+966', '+966 (Saudi Arabia)'),
        ('+221', '+221 (Senegal)'),
        ('+381', '+381 (Serbia)'),
        ('+248', '+248 (Seychelles)'),
        ('+232', '+232 (Sierra Leone)'),
        ('+65', '+65 (Singapore)'),
        ('+421', '+421 (Slovakia)'),
        ('+386', '+386 (Slovenia)'),
        ('+677', '+677 (Solomon Islands)'),
        ('+252', '+252 (Somalia)'),
        ('+27', '+27 (South Africa)'),
        ('+82', '+82 (South Korea)'),
        ('+211', '+211 (South Sudan)'),
        ('+34', '+34 (Spain)'),
        ('+94', '+94 (Sri Lanka)'),
        ('+249', '+249 (Sudan)'),
        ('+597', '+597 (Suriname)'),
        ('+46', '+46 (Sweden)'),
        ('+41', '+41 (Switzerland)'),
        ('+963', '+963 (Syria)'),
        ('+886', '+886 (Taiwan)'),
        ('+992', '+992 (Tajikistan)'),
        ('+255', '+255 (Tanzania)'),
        ('+66', '+66 (Thailand)'),
        ('+670', '+670 (Timor-Leste)'),
        ('+228', '+228 (Togo)'),
        ('+676', '+676 (Tonga)'),
        ('+1-868', '+1-868 (Trinidad and Tobago)'),
        ('+216', '+216 (Tunisia)'),
        ('+90', '+90 (Turkey)'),
        ('+993', '+993 (Turkmenistan)'),
        ('+688', '+688 (Tuvalu)'),
        ('+256', '+256 (Uganda)'),
        ('+380', '+380 (Ukraine)'),
        ('+971', '+971 (United Arab Emirates)'),
        ('+44', '+44 (United Kingdom)'),
        ('+1', '+1 (United States)'),
        ('+598', '+598 (Uruguay)'),
        ('+998', '+998 (Uzbekistan)'),
        ('+678', '+678 (Vanuatu)'),
        ('+379', '+379 (Vatican City)'),
        ('+58', '+58 (Venezuela)'),
        ('+84', '+84 (Vietnam)'),
        ('+967', '+967 (Yemen)'),
        ('+260', '+260 (Zambia)'),
        ('+263', '+263 (Zimbabwe)'), ('+', 'Other'),]

    country_code = forms.ChoiceField(
        choices=COUNTRY_CODE_CHOICES,
        required=True,
        label="Country Code",
        error_messages={
            'required': 'Please enter your country code.',
        },
        widget=forms.Select(attrs={'class': 'form-select'})
    )

    mobile_number = forms.CharField(
        required=True,
        label="Mobile Number",
        
        error_messages={
            'required': 'Please enter your mobile number.',
        },
        widget=forms.NumberInput(attrs={
            'placeholder': 'Enter mobile number',
            'class': 'form-control',
            # "data-clarity-unmask": "true",
            # "data-clarity-privacy": "unmasked",
        })
    )

    message = forms.CharField(
        required=True,
        label="Message",
        error_messages={
            'required': 'Please enter your message.',
        },
        widget=forms.Textarea(attrs={
            'placeholder': 'Describe your product requirement in a few lines...',
            'class': 'form-control',
            'rows': 4,
            # "data-clarity-unmask": "true",
            # "data-clarity-privacy": "unmasked",
        })
    )

    def clean_mobile_number(self):
        mobile = self.cleaned_data.get('mobile_number', '').strip()
        country_code = self.cleaned_data.get('country_code', '')

        # Remove country code if user typed it in mobile field
        if country_code and mobile.startswith(country_code.replace("+", "")):
            mobile = mobile[len(country_code.replace("+", "")):]

        # Remove "+" if user added it mistakenly
        mobile = re.sub(r'^\+?', '', mobile)

        # Only allow digits
        if not mobile.isdigit():
            raise forms.ValidationError("Mobile number should contain digits only.")

        # Generic length check (can be customized per country if needed)
        if len(mobile) < 6 or len(mobile) > 15:
            raise forms.ValidationError("Mobile number must be between 6 and 15 digits.")

        return mobile
