document.addEventListener("DOMContentLoaded", function () {
  const elements = document.querySelectorAll(".box-image2, .verticalization-block");

  const observerOptions = {
    root: null, // Use the viewport as the root
    rootMargin: "0px",
    threshold: 0.1, // Trigger when 10% of the element is in view
  };

  const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        entry.target.classList.add("visible");
      } else {
        entry.target.classList.remove("visible");
      }
    });
  }, observerOptions);

  elements.forEach((element) => {
    observer.observe(element);
  });
});
