// ==========================
// Demo Popup Open/Close
// ==========================
// fetch(form.action, {
//   method: "POST",
//   body: new FormData(form)
// })
// .then(response => response.json())
// .then(data => {
//   if (data.redirect_url) {
//     window.open(data.redirect_url, '_blank');  // open thank-you in new tab
//   }
// });

// document.addEventListener("DOMContentLoaded", () => {
//     const form = document.getElementById("iot-demo-form");

//     if (form) {
//         form.addEventListener("submit", function (e) {
//             e.preventDefault();  // Stop the default browser submission

//             const formData = new FormData(form);

//             fetch(form.action, {
//                 method: "POST",
//                 body: formData,
//                 headers: {
//                     "X-Requested-With": "XMLHttpRequest",
//                 },
//             })
//             .then(response => response.json())
//             .then(data => {
//                 if (data.redirect_url) {
//                     window.open(data.redirect_url, '_blank'); // Open thank-you in new tab
//                 }
//             })
//             .catch(error => {
//                 alert("Submission failed. Please try again.");
//                 console.error("Error:", error);
//             });
//         });
//     }
// });
function openTelecomInquiry() {
    document.getElementById("telecomInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeTelecomInquiry() {
    document.getElementById("telecomInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

// ✅ Popup Control for BESS Design
function openBessInquiry() {
    document.getElementById("bessInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeBessInquiry() {
    document.getElementById("bessInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}
// ✅ Open/Close Popup for Green & Renewable Energy
function openGreenInquiry() {
    document.getElementById("greenInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeGreenInquiry() {
    document.getElementById("greenInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}


function openCmmsDemo() {
    document.getElementById("cmmsDemoPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeCmmsDemo() {
    document.getElementById("cmmsDemoPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

function openXgslabDemo() {
    document.getElementById("xgslabDemoPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeXgslabDemo() {
    document.getElementById("xgslabDemoPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}
function openNeplanDemo() {
    document.getElementById("neplanDemoPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeNeplanDemo() {
    document.getElementById("neplanDemoPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

function openPowerBIDemo() {
    document.getElementById("powerbiDemoPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closePowerBIDemo() {
    document.getElementById("powerbiDemoPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

function openEmsDemo() {
    document.getElementById("emsDemoPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeEmsDemo() {
    document.getElementById("emsDemoPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}


function openIotDemo() {
    document.getElementById("iotDemoPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeIotDemo() {
    document.getElementById("iotDemoPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

function openPowerdesignDemo() {
    document.getElementById("powerdesignDemoPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closePowerdesignDemo() {
    document.getElementById("powerdesignDemoPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}


function openGseInquiry() {
    document.getElementById("gseInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeGseInquiry() {
    document.getElementById("gseInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

function openAspDesign() {
    document.getElementById("aspDesignPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeAspDesign() {
    document.getElementById("aspDesignPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

function openPowerSystemDesign() {
    document.getElementById("powerSystemDesignPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closePowerSystemDesign() {
    document.getElementById("powerSystemDesignPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}
function openEarthingInquiry() {
    document.getElementById("earthingInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeEarthingInquiry() {
    document.getElementById("earthingInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

function openHvismpInquiry() {
    document.getElementById("hvismpInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeHvismpInquiry() {
    document.getElementById("hvismpInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

function openAutomationInquiry() {
    document.getElementById("automationInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeAutomationInquiry() {
    document.getElementById("automationInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}


function closeThankYouPopup() {
    document.getElementById("thankYouPopup").style.display = "none";
    location.reload();
}

// ✅ Popup control for HV Panel Design
function openHvPanelInquiry() {
    document.getElementById("hvPanelInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeHvPanelInquiry() {
    document.getElementById("hvPanelInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

// ✅ Popup control for Data Center Solutions
function openDatacenterInquiry() {
    document.getElementById("datacenterInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
  }
  
  function closeDatacenterInquiry() {
    document.getElementById("datacenterInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
  }
  
// ✅ Popup Control for Energy Audit
function openEnergyAuditInquiry() {
    document.getElementById("energyAuditInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeEnergyAuditInquiry() {
    document.getElementById("energyAuditInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

// Open/Close Popup Functions
function openPolesInquiry() {
    document.getElementById("polesInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closePolesInquiry() {
    document.getElementById("polesInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

// ✅ Open/Close Popup for Power Cable and Accessories
function openPowerInquiry() {
    document.getElementById("powerInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closePowerInquiry() {
    document.getElementById("powerInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

// ✅ Open/Close Popup for Fusion Splicer
function openFiberFusionSplicerInquiry() {
    document.getElementById("fusionSplicerInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeFiberFusionSplicerInquiry() {
    document.getElementById("fusionSplicerInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}


// ✅ Open/Close Popup for Termination Kits
function openTerminationInquiry() {
    document.getElementById("terminationInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeTerminationInquiry() {
    document.getElementById("terminationInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

// ✅ Open/Close Popup for Maintenance Excellence Cost Saving
function openMaintenanceInquiry() {
    document.getElementById("maintenanceInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeMaintenanceInquiry() {
    document.getElementById("maintenanceInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}
// ✅ Popup control for RPEQ Services
function openRpeqInquiry() {
    document.getElementById("rpeqInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeRpeqInquiry() {
    document.getElementById("rpeqInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}


// ✅ Fiber Cables & Accessories
function openFiberCablesInquiry() {
    document.getElementById("fiberCablesInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeFiberCablesInquiry() {
    document.getElementById("fiberCablesInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

// ✅ Popup control for Project Management Inquiry
function openProjectMgmtInquiry() {
    document.getElementById("projectMgmtInquiryPopup").style.display = "flex";
    document.body.classList.add("cmms-demo-lock");
}

function closeProjectMgmtInquiry() {
    document.getElementById("projectMgmtInquiryPopup").style.display = "none";
    document.body.classList.remove("cmms-demo-lock");
}

// ==========================
// AJAX Form Submission for Multiple Forms
// ==========================
document.addEventListener('DOMContentLoaded', function () {

    const forms = document.querySelectorAll('form.cmms-demo-grid');

    forms.forEach(form => {
        const submitBtn = form.querySelector(".cmms-demo-submit");
        const submitText = submitBtn.querySelector("#submitText");
        const loadingSpinner = submitBtn.querySelector("#loadingSpinner");

        form.addEventListener('submit', function (e) {
            e.preventDefault();

            submitText.textContent = "Submitting...";
            loadingSpinner.style.display = "inline-block";
            submitBtn.disabled = true;

            const formData = new FormData(form);

            fetch(form.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRFToken': document.querySelector('[name=csrfmiddlewaretoken]').value
                }
            })
                .then(response => response.json())
                // For Pop up message
                // .then(data => {
                //     if (data.status === 'success') {
                //         // Close current popup
                //         const popup = form.closest('.cmms-demo-popup');
                //         if (popup) popup.style.display = 'none';

                //         // Show thank you popup
                //         document.getElementById("thankYouPopup").style.display = "flex";
                //         form.reset();
                //     } else {
                //         alert("Error: Something went wrong.");
                //     }
                // })
                // for new thank-u page
                .then(data => {
                    if (data.status === 'error') {
                        // ✅ Show the message in a popup alert
                        alert(data.message);
                        // ✅ Reset reCAPTCHA
                        if (typeof grecaptcha !== "undefined") {
                            grecaptcha.reset();  // This will re-show the checkbox
                        }

                        // 🔁 Reset button states
                        submitText.textContent = "Submit";
                        loadingSpinner.style.display = "none";
                        submitBtn.disabled = false;

                        return; // 🛑 Don't continue to redirect
                    }

                    if (data.redirect_url) {
                        window.location.href = data.redirect_url;
                    } else {
                        alert("Something went wrong.");
                        submitText.textContent = "Submit";
                        loadingSpinner.style.display = "none";
                        submitBtn.disabled = false;
                    }
                })


                .catch(error => {
                    console.error('Error:', error);
                    alert("Submission failed. Please try again.");

                    if (typeof grecaptcha !== "undefined") {
                        grecaptcha.reset();
                    }

                    submitText.textContent = "Submit";
                    loadingSpinner.style.display = "none";
                    submitBtn.disabled = false;
                });
        });
    });

    document.querySelector('.thank-you-button').addEventListener('click', closeThankYouPopup);
});


// ==========================
// Load Country Codes
// ==========================
document.addEventListener('DOMContentLoaded', function () {
    const countryCodes = [{ name: "Afghanistan", code: "+93" },
    { name: "Albania", code: "+355" },
    { name: "Algeria", code: "+213" },
    { name: "Andorra", code: "+376" },
    { name: "Angola", code: "+244" },
    { name: "Argentina", code: "+54" },
    { name: "Armenia", code: "+374" },
    { name: "Australia", code: "+61" },
    { name: "Austria", code: "+43" },
    { name: "Azerbaijan", code: "+994" },
    { name: "Bahamas", code: "+1-242" },
    { name: "Bahrain", code: "+973" },
    { name: "Bangladesh", code: "+880" },
    { name: "Barbados", code: "+1-246" },
    { name: "Belarus", code: "+375" },
    { name: "Belgium", code: "+32" },
    { name: "Belize", code: "+501" },
    { name: "Benin", code: "+229" },
    { name: "Bhutan", code: "+975" },
    { name: "Bolivia", code: "+591" },
    { name: "Bosnia and Herzegovina", code: "+387" },
    { name: "Botswana", code: "+267" },
    { name: "Brazil", code: "+55" },
    { name: "Brunei", code: "+673" },
    { name: "Bulgaria", code: "+359" },
    { name: "Burkina Faso", code: "+226" },
    { name: "Burundi", code: "+257" },
    { name: "Cambodia", code: "+855" },
    { name: "Cameroon", code: "+237" },
    { name: "Canada", code: "+1" },
    { name: "Cape Verde", code: "+238" },
    { name: "Central African Republic", code: "+236" },
    { name: "Chad", code: "+235" },
    { name: "Chile", code: "+56" },
    { name: "China", code: "+86" },
    { name: "Colombia", code: "+57" },
    { name: "Comoros", code: "+269" },
    { name: "Costa Rica", code: "+506" },
    { name: "Croatia", code: "+385" },
    { name: "Cuba", code: "+53" },
    { name: "Cyprus", code: "+357" },
    { name: "Czech Republic", code: "+420" },
    { name: "Denmark", code: "+45" },
    { name: "Djibouti", code: "+253" },
    { name: "Dominica", code: "+1-767" },
    { name: "Dominican Republic", code: "+1-809" },
    { name: "Ecuador", code: "+593" },
    { name: "Egypt", code: "+20" },
    { name: "El Salvador", code: "+503" },
    { name: "Equatorial Guinea", code: "+240" },
    { name: "Eritrea", code: "+291" },
    { name: "Estonia", code: "+372" },
    { name: "Eswatini", code: "+268" },
    { name: "Ethiopia", code: "+251" },
    { name: "Fiji", code: "+679" },
    { name: "Finland", code: "+358" },
    { name: "France", code: "+33" },
    { name: "Gabon", code: "+241" },
    { name: "Gambia", code: "+220" },
    { name: "Georgia", code: "+995" },
    { name: "Germany", code: "+49" },
    { name: "Ghana", code: "+233" },
    { name: "Greece", code: "+30" },
    { name: "Grenada", code: "+1-473" },
    { name: "Guatemala", code: "+502" },
    { name: "Guinea", code: "+224" },
    { name: "Guyana", code: "+592" },
    { name: "Haiti", code: "+509" },
    { name: "Honduras", code: "+504" },
    { name: "Hungary", code: "+36" },
    { name: "Iceland", code: "+354" },
    { name: "India", code: "+91" },
    { name: "Indonesia", code: "+62" },
    { name: "Iran", code: "+98" },
    { name: "Iraq", code: "+964" },
    { name: "Ireland", code: "+353" },
    { name: "Israel", code: "+972" },
    { name: "Italy", code: "+39" },
    { name: "Ivory Coast", code: "+225" },
    { name: "Jamaica", code: "+1-876" },
    { name: "Japan", code: "+81" },
    { name: "Jordan", code: "+962" },
    { name: "Kazakhstan", code: "+7" },
    { name: "Kenya", code: "+254" },
    { name: "Kiribati", code: "+686" },
    { name: "Kuwait", code: "+965" },
    { name: "Kyrgyzstan", code: "+996" },
    { name: "Laos", code: "+856" },
    { name: "Latvia", code: "+371" },
    { name: "Lebanon", code: "+961" },
    { name: "Lesotho", code: "+266" },
    { name: "Liberia", code: "+231" },
    { name: "Libya", code: "+218" },
    { name: "Liechtenstein", code: "+423" },
    { name: "Lithuania", code: "+370" },
    { name: "Luxembourg", code: "+352" },
    { name: "Madagascar", code: "+261" },
    { name: "Malawi", code: "+265" },
    { name: "Malaysia", code: "+60" },
    { name: "Maldives", code: "+960" },
    { name: "Mali", code: "+223" },
    { name: "Malta", code: "+356" },
    { name: "Marshall Islands", code: "+692" },
    { name: "Mauritania", code: "+222" },
    { name: "Mauritius", code: "+230" },
    { name: "Mexico", code: "+52" },
    { name: "Micronesia", code: "+691" },
    { name: "Moldova", code: "+373" },
    { name: "Monaco", code: "+377" },
    { name: "Mongolia", code: "+976" },
    { name: "Montenegro", code: "+382" },
    { name: "Morocco", code: "+212" },
    { name: "Mozambique", code: "+258" },
    { name: "Myanmar", code: "+95" },
    { name: "Namibia", code: "+264" },
    { name: "Nauru", code: "+674" },
    { name: "Nepal", code: "+977" },
    { name: "Netherlands", code: "+31" },
    { name: "New Zealand", code: "+64" },
    { name: "Nicaragua", code: "+505" },
    { name: "Niger", code: "+227" },
    { name: "Nigeria", code: "+234" },
    { name: "North Korea", code: "+850" },
    { name: "North Macedonia", code: "+389" },
    { name: "Norway", code: "+47" },
    { name: "Oman", code: "+968" },
    { name: "Pakistan", code: "+92" },
    { name: "Palau", code: "+680" },
    { name: "Panama", code: "+507" },
    { name: "Papua New Guinea", code: "+675" },
    { name: "Paraguay", code: "+595" },
    { name: "Peru", code: "+51" },
    { name: "Philippines", code: "+63" },
    { name: "Poland", code: "+48" },
    { name: "Portugal", code: "+351" },
    { name: "Qatar", code: "+974" },
    { name: "Republic of the Congo", code: "+242" },
    { name: "Romania", code: "+40" },
    { name: "Russia", code: "+7" },
    { name: "Rwanda", code: "+250" },
    { name: "Saint Kitts and Nevis", code: "+1-869" },
    { name: "Saint Lucia", code: "+1-758" },
    { name: "Saint Vincent and the Grenadines", code: "+1-784" },
    { name: "Samoa", code: "+685" },
    { name: "San Marino", code: "+378" },
    { name: "Saudi Arabia", code: "+966" },
    { name: "Senegal", code: "+221" },
    { name: "Serbia", code: "+381" },
    { name: "Seychelles", code: "+248" },
    { name: "Sierra Leone", code: "+232" },
    { name: "Singapore", code: "+65" },
    { name: "Slovakia", code: "+421" },
    { name: "Slovenia", code: "+386" },
    { name: "Solomon Islands", code: "+677" },
    { name: "Somalia", code: "+252" },
    { name: "South Africa", code: "+27" },
    { name: "South Korea", code: "+82" },
    { name: "South Sudan", code: "+211" },
    { name: "Spain", code: "+34" },
    { name: "Sri Lanka", code: "+94" },
    { name: "Sudan", code: "+249" },
    { name: "Suriname", code: "+597" },
    { name: "Sweden", code: "+46" },
    { name: "Switzerland", code: "+41" },
    { name: "Syria", code: "+963" },
    { name: "Taiwan", code: "+886" },
    { name: "Tajikistan", code: "+992" },
    { name: "Tanzania", code: "+255" },
    { name: "Thailand", code: "+66" },
    { name: "Timor-Leste", code: "+670" },
    { name: "Togo", code: "+228" },
    { name: "Tonga", code: "+676" },
    { name: "Trinidad and Tobago", code: "+1-868" },
    { name: "Tunisia", code: "+216" },
    { name: "Turkey", code: "+90" },
    { name: "Turkmenistan", code: "+993" },
    { name: "Tuvalu", code: "+688" },
    { name: "Uganda", code: "+256" },
    { name: "Ukraine", code: "+380" },
    { name: "United Arab Emirates", code: "+971" },
    { name: "United Kingdom", code: "+44" },
    { name: "United States", code: "+1" },
    { name: "Uruguay", code: "+598" },
    { name: "Uzbekistan", code: "+998" },
    { name: "Vanuatu", code: "+678" },
    { name: "Vatican City", code: "+379" },
    { name: "Venezuela", code: "+58" },
    { name: "Vietnam", code: "+84" },
    { name: "Yemen", code: "+967" },
    { name: "Zambia", code: "+260" },
    { name: "Zimbabwe", code: "+263" },
    { name: "Other", code: "" }]; // Your full list already present
    const selects = document.querySelectorAll('select[name="country_code"]');
    selects.forEach(selectCode => {
        countryCodes.forEach(country => {
            const option = document.createElement('option');
            option.value = country.code;
            option.textContent = `${country.name} (${country.code})`;
            selectCode.appendChild(option);
        });
    });
});
// ==========================
// Match Country on Phone Blur
// ==========================
document.addEventListener('DOMContentLoaded', function () {
    const phones = document.querySelectorAll('input[name="phone"]');

    phones.forEach(phoneInput => {
        phoneInput.addEventListener('blur', function () {
            const form = phoneInput.closest('form');
            const countrySelect = form.querySelector('select[name="country_code"]');

            const codeMap = {};
            for (let i = 0; i < countrySelect.options.length; i++) {
                const option = countrySelect.options[i];
                if (option.value) {
                    codeMap[option.value.replace(/\s/g, "")] = option;
                }
            }

            const rawInput = phoneInput.value.trim().replace(/\s/g, "");

            if (!rawInput.startsWith("+")) return;

            const sortedCodes = Object.keys(codeMap).sort((a, b) => b.length - a.length);

            let matched = false;
            for (const code of sortedCodes) {
                if (rawInput.startsWith(code)) {
                    countrySelect.value = code;
                    matched = true;
                    break;
                }
            }

            if (!matched) {
                alert("❌ Invalid country code. Please correct it.");
                countrySelect.value = "";
            }
        });
    });
});

// ==========================
// Highlight Demo Button
// ==========================
document.addEventListener("DOMContentLoaded", () => {
    // Handle CARL Demo Button
    const demoBtn = document.querySelector(".demo-button");
    if (demoBtn) {
        demoBtn.classList.add("highlight");

        demoBtn.addEventListener("animationend", () => {
            demoBtn.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtn.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtn.classList.add("highlight");
            }
        });
    }

// ✅ Animate Data Center Button on Scroll
const demoBtnDatacenter = document.querySelector(".demo-button-data-center");
if (demoBtnDatacenter) {
  demoBtnDatacenter.classList.add("highlight");

  demoBtnDatacenter.addEventListener("animationend", () => {
    demoBtnDatacenter.classList.remove("highlight");
  });

  window.addEventListener("scroll", () => {
    const rect = demoBtnDatacenter.getBoundingClientRect();
    if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
      demoBtnDatacenter.classList.add("highlight");
    }
  });
}
    // ✅ Handle Earthing Inquiry Button
    const demoBtnEarthing = document.querySelector(".demo-button-earthing");
    if (demoBtnEarthing) {
        demoBtnEarthing.classList.add("highlight");

        demoBtnEarthing.addEventListener("animationend", () => {
            demoBtnEarthing.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnEarthing.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnEarthing.classList.add("highlight");
            }
        });
    }

    // ✅ Animate Project Management Button on Scroll
    const demoBtnProjectMgmt = document.querySelector(".demo-button-projectmgmt");
    if (demoBtnProjectMgmt) {
        demoBtnProjectMgmt.classList.add("highlight");

        demoBtnProjectMgmt.addEventListener("animationend", () => {
            demoBtnProjectMgmt.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnProjectMgmt.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnProjectMgmt.classList.add("highlight");
            }
        });
    }

    // ✅ Animate Button on Scroll (if using demo-button-green class)
    const demoBtnGreen = document.querySelector(".demo-button-green");
    if (demoBtnGreen) {
        demoBtnGreen.classList.add("highlight");

        demoBtnGreen.addEventListener("animationend", () => {
            demoBtnGreen.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnGreen.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnGreen.classList.add("highlight");
            }
        });
    }
    // ✅ Animate Button on Scroll (for Maintenance Excellence button)
    const demoBtnMaintenance = document.querySelector(".demo-button-maintenance-design");
    if (demoBtnMaintenance) {
        demoBtnMaintenance.classList.add("highlight");

        demoBtnMaintenance.addEventListener("animationend", () => {
            demoBtnMaintenance.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnMaintenance.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnMaintenance.classList.add("highlight");
            }
        });
    }



    // ✅ Animate Button on Scroll
    const demoBtnBess = document.querySelector(".demo-button-bess");
    if (demoBtnBess) {
        demoBtnBess.classList.add("highlight");

        demoBtnBess.addEventListener("animationend", () => {
            demoBtnBess.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnBess.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnBess.classList.add("highlight");
            }
        });
    }

    // ✅ Animate RPEQ Button on Scroll
    const demoBtnRpeq = document.querySelector(".demo-button-rpeq");
    if (demoBtnRpeq) {
        demoBtnRpeq.classList.add("highlight");

        demoBtnRpeq.addEventListener("animationend", () => {
            demoBtnRpeq.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnRpeq.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnRpeq.classList.add("highlight");
            }
        });
    }

    
    // ✅ Animate Fiber Cables & Accessories Button on Scroll
    const demoBtnFiberCable = document.querySelector(".demo-button-fiber-cable");
    if (demoBtnFiberCable) {
        demoBtnFiberCable.classList.add("highlight");

        demoBtnFiberCable.addEventListener("animationend", () => {
            demoBtnFiberCable.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnFiberCable.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnFiberCable.classList.add("highlight");
            }
        });
    }

    
    // ✅ Animate Fiber Cables & Accessories Button on Scroll
    const demoBtnFiberFusion = document.querySelector(".demo-button-fiber-fusion");
    if (demoBtnFiberFusion) {
        demoBtnFiberFusion.classList.add("highlight");

        demoBtnFiberFusion.addEventListener("animationend", () => {
            demoBtnFiberFusion.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnFiberFusion.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnFiberFusion.classList.add("highlight");
            }
        });
    }
    // ✅ Animate HV Panel Button on Scroll
    const demoBtnHvPanel = document.querySelector(".demo-button-hv-panel-design");
    if (demoBtnHvPanel) {
        demoBtnHvPanel.classList.add("highlight");

        demoBtnHvPanel.addEventListener("animationend", () => {
            demoBtnHvPanel.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnHvPanel.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnHvPanel.classList.add("highlight");
            }
        });
    }
    // ✅ Animate Inquiry Button on Scroll
    const demoBtnEnergyAudit = document.querySelector(".demo-button-energy-audit");
    if (demoBtnEnergyAudit) {
        demoBtnEnergyAudit.classList.add("highlight");

        demoBtnEnergyAudit.addEventListener("animationend", () => {
            demoBtnEnergyAudit.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnEnergyAudit.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnEnergyAudit.classList.add("highlight");
            }
        });
    }

    // ✅ Animate Button on Scroll
    const demoBtnTelecom = document.querySelector(".demo-button-telecom");
    if (demoBtnTelecom) {
        demoBtnTelecom.classList.add("highlight");

        demoBtnTelecom.addEventListener("animationend", () => {
            demoBtnTelecom.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnTelecom.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnTelecom.classList.add("highlight");
            }
        });
    }

    // ✅ Animate Button on Scroll
    const demoBtnTermination = document.querySelector(".demo-button-termination");
    if (demoBtnTermination) {
        demoBtnTermination.classList.add("highlight");

        demoBtnTermination.addEventListener("animationend", () => {
            demoBtnTermination.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnTermination.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnTermination.classList.add("highlight");
            }
        });
    }

    // ✅ Handle Automation Inquiry Button
    const demoBtnAutomation = document.querySelector(".demo-button-automation");
    if (demoBtnAutomation) {
        demoBtnAutomation.classList.add("highlight");

        demoBtnAutomation.addEventListener("animationend", () => {
            demoBtnAutomation.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnAutomation.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnAutomation.classList.add("highlight");
            }
        });
    }
    // ✅ Handle Poles Inquiry Button
    const demoBtnPoles = document.querySelector(".demo-button-poles");

    if (demoBtnPoles) {
        demoBtnPoles.classList.add("highlight");

        demoBtnPoles.addEventListener("animationend", () => {
            demoBtnPoles.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnPoles.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnPoles.classList.add("highlight");
            }
        });
    }

    // Handle XGS LAB Demo Button
    const demoBtnXgs = document.querySelector(".demo-button-xgs");
    if (demoBtnXgs) {
        demoBtnXgs.classList.add("highlight");

        demoBtnXgs.addEventListener("animationend", () => {
            demoBtnXgs.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnXgs.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnXgs.classList.add("highlight");
            }
        });
    }

    // ✅ Handle Power Cable Inquiry Button
    // const demoBtnPowerCable = document.querySelector(".demo-button-power-cable");
    // if (demoBtnPowerCable) {
    //     demoBtnPowerCable.classList.add("highlight");

    //     demoBtnPowerCable.addEventListener("animationend", () => {
    //         demoBtnPowerCable.classList.remove("highlight");
    //     });

    //     window.addEventListener("scroll", () => {
    //         const rect = demoBtnPowerCable.getBoundingClientRect();
    //         if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
    //             demoBtnPowerCable.classList.add("highlight");
    //         }
    //     });
    // }
    const demoBtnNeplan = document.querySelector(".demo-button-neplan");
    if (demoBtnNeplan) {
        demoBtnNeplan.classList.add("highlight");

        demoBtnNeplan.addEventListener("animationend", () => {
            demoBtnNeplan.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnNeplan.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnNeplan.classList.add("highlight");
            }
        });
    }

    // ✅ Handle GSE Inquiry Button
    const demoBtnGse = document.querySelector(".demo-button-gse");
    if (demoBtnGse) {
        demoBtnGse.classList.add("highlight");

        demoBtnGse.addEventListener("animationend", () => {
            demoBtnGse.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnGse.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnGse.classList.add("highlight");
            }
        });
    }
    // ✅ Handle Power System Studies & Design Inquiry Button
    const demoBtnPower = document.querySelector(".demo-button-power");
    if (demoBtnPower) {
        demoBtnPower.classList.add("highlight");

        demoBtnPower.addEventListener("animationend", () => {
            demoBtnPower.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnPower.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnPower.classList.add("highlight");
            }
        });
    }


    // ✅ Handle ASP Inquiry Button
    const demoBtnAsp = document.querySelector(".demo-button-asp");

    if (demoBtnAsp) {
        // Trigger animation once on page load
        demoBtnAsp.classList.add("highlight");

        // Remove animation class after it ends
        demoBtnAsp.addEventListener("animationend", () => {
            demoBtnAsp.classList.remove("highlight");
        });

        // Add animation class again when scrolled into view
        window.addEventListener("scroll", () => {
            const rect = demoBtnAsp.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnAsp.classList.add("highlight");
            }
        });
    }


    // ✅ Handle powerbi labn Inquiry Button
    const demoBtnPowerBI = document.querySelector(".demo-button-powerbi");
    if (demoBtnPowerBI) {
        demoBtnPowerBI.classList.add("highlight");

        demoBtnPowerBI.addEventListener("animationend", () => {
            demoBtnPowerBI.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnPowerBI.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnPowerBI.classList.add("highlight");
            }
        });
    }
    // ✅ Handle HVISMP Inquiry Button
    const demoBtnHvismp = document.querySelector(".demo-button-hvismp");
    if (demoBtnHvismp) {
        demoBtnHvismp.classList.add("highlight");

        demoBtnHvismp.addEventListener("animationend", () => {
            demoBtnHvismp.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnHvismp.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnHvismp.classList.add("highlight");
            }
        });
    }

    const demoBtnEMS = document.querySelector(".demo-button-ems");
    if (demoBtnEMS) {
        demoBtnEMS.classList.add("highlight");

        demoBtnEMS.addEventListener("animationend", () => {
            demoBtnEMS.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnEMS.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnEMS.classList.add("highlight");
            }
        });
    }
    const demoBtnIOT = document.querySelector(".demo-button-iot");
    if (demoBtnIOT) {
        demoBtnIOT.classList.add("highlight");

        demoBtnIOT.addEventListener("animationend", () => {
            demoBtnIOT.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnIOT.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnIOT.classList.add("highlight");
            }
        });

    }

    const demoBtnPowerdesign = document.querySelector(".demo-button-powerdesign");
    if (demoBtnPowerdesign) {
        demoBtnPowerdesign.classList.add("highlight");

        demoBtnPowerdesign.addEventListener("animationend", () => {
            demoBtnPowerdesign.classList.remove("highlight");
        });

        window.addEventListener("scroll", () => {
            const rect = demoBtnPowerdesign.getBoundingClientRect();
            if (rect.top >= 0 && rect.top <= window.innerHeight - 300) {
                demoBtnPowerdesign.classList.add("highlight");
            }
        });

    }


});


