document.addEventListener('DOMContentLoaded', function() {
    const contentSections = document.querySelectorAll('.rpeq-content-section','.rpeq-key-container');

    const handleScroll = () => {
        contentSections.forEach(section => {
            const sectionTop = section.getBoundingClientRect().top;
            const triggerPoint = window.innerHeight - 100;

            if (sectionTop < triggerPoint) {
                section.classList.add('visible');
            } else {
                section.classList.remove('visible');
            }
        });
    };

    window.addEventListener('scroll', handleScroll);
    handleScroll(); // Initial check in case the section is already in view
});