document.addEventListener("DOMContentLoaded", function() {
    const points = document.querySelectorAll('.data-center-points-list .data-center-points-point');
    
    // Function to check if an element is in the viewport
    function isInViewport(element) {
        const rect = element.getBoundingClientRect();
        return (
            rect.top >= 0 &&
            rect.left >= 0 &&
            rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
            rect.right <= (window.innerWidth || document.documentElement.clientWidth)
        );
    }

    // Trigger animation when the element enters the viewport
    function checkAnimation() {
        points.forEach(point => {
            if (isInViewport(point)) {
                point.classList.add('active');
            }
        });
    }

    // Listen for scroll events
    window.addEventListener('scroll', checkAnimation);

    // Initial check
    checkAnimation();
});
