// Get the elements
const searchBox = document.querySelector('.box');
const input = searchBox.querySelector('input');
const searchIcon = searchBox.querySelector('a');

// Add click event listener to the search icon
searchIcon.addEventListener('click', (e) => {
    e.preventDefault(); // Prevent default anchor behavior
    performSearch(); // Call the search function
});

// Add click event listener to the box
searchBox.addEventListener('click', () => {
    input.focus(); // Focus on the input when the box is clicked
    if (input.value === '') {
        input.style.width = '200px'; // Expand input width
    }
});

// Add blur event listener to the input
input.addEventListener('blur', () => {
    if (input.value === '') {
        input.style.width = '0'; // Collapse input width if empty
    }
});

// Function to perform the search
function performSearch() {
    const query = input.value.trim(); // Get the input value
    if (query) {
        alert(`Searching for: ${query}`); // Placeholder action for search
        // Here, you can implement actual search logic (e.g., redirecting, filtering results, etc.)
    }
}
