from django.shortcuts import render, redirect
from django.contrib import messages
from .forms import ContactForm
from .models import Contact
from django.core.mail import send_mail
from django.conf import settings
from django.http import HttpResponse
from django.contrib.staticfiles.storage import staticfiles_storage
from django.http import JsonResponse
import requests

from django.core.validators import validate_email
from django.core.exceptions import ValidationError
import re

# Example data for suggestions
ITEMS = [
    {"name": "Software", "url": "/software/"},
  
]
def carl_demo(request):
    return render(request, 'cmms-demo-book-demo.html')


# Add a list of known spam or disposable domains
# ✅ Blocked domains
BLOCKED_DOMAINS = [
    "mail-hq.store", "tempmail.com", "10minutemail.com", "mailinator.com",
    "dispostable.com", "store.com", "fakeinbox.com", "guerrillamail.com",
    "sharklasers.com", "spamgourmet.com", "testform.xyz", "com.au.store"
]

def is_blocked_email(email):
    try:
        domain = email.split('@')[1].lower()
        return any(blocked in domain for blocked in BLOCKED_DOMAINS)
    except IndexError:
        return True  # Malformed = treat as blocked

def is_valid_name(name):
    return bool(re.match(r'^[a-zA-Z\s\-]{2,50}$', name))

def cmms_demo_popup_submit(request):
    if request.method == 'POST':
        # ✅ Honeypot check
        if request.POST.get('company_name'):
            return JsonResponse({'status': 'error', 'message': 'Bot submission blocked.'})

        # ✅ reCAPTCHA check
        recaptcha_response = request.POST.get('g-recaptcha-response')
        r = requests.post('https://www.google.com/recaptcha/api/siteverify', data={
            'secret': settings.RECAPTCHA_PRIVATE_KEY,
            'response': recaptcha_response
        })
        if not r.json().get('success'):
            return JsonResponse({'status': 'error', 'message': '⚠️ reCAPTCHA verification failed. Please try again.'})

        # ✅ Extract fields
        first_name = request.POST.get('first_name', '').strip()
        last_name = request.POST.get('last_name', '').strip()
        name = f"{first_name} {last_name}".strip()
        email = request.POST.get('email', '').strip()
        phone = request.POST.get('phone', '').strip()
        country_code = request.POST.get('country_code', '').strip()
        full_phone = f"{country_code} {phone}".strip()
        expectations = request.POST.get('interest', '').strip()
        subject = request.POST.get('form_title', 'Demo Request')

        # ✅ Validate name
        if not is_valid_name(first_name):
            return JsonResponse({'status': 'error', 'message': '❌ Please enter a valid name (letters, spaces, hyphens only).'})

        # ✅ Validate email
        try:
            validate_email(email)
        except ValidationError:
            return JsonResponse({'status': 'error', 'message': '❌ Please enter a valid email address.'})

        if is_blocked_email(email):
            return JsonResponse({'status': 'error', 'message': '❌ This email domain is not allowed.'})

        # ✅ Compose email
        message = f"""
        {subject}

        Name: {name}
        Email: {email}
        Phone: {full_phone}
        Expectations: {expectations}
        """

        # ✅ Send mail
        send_mail(
            subject,
            message,
            settings.DEFAULT_FROM_EMAIL,
            ['test@ieng.tech', 'shila@iengaust.com.au', 'diksha@iengaust.com.au', 'mayur@iengaust.com.au'],
            fail_silently=False,
        )

        return JsonResponse({'redirect_url': '/thank-you/'})

    return redirect('/')
def register_popup_submit(request):
    if request.method == 'POST':
        name = request.POST.get('name')
        email = request.POST.get('email')
        phone = request.POST.get('phone')
        college = request.POST.get('college')
        degree = request.POST.get('degree')
        year = request.POST.get('year')

        subject = "New Registration Submission"
        message = f"""
        New registration received:

        Name: {name}
        Email: {email}
        Phone: {phone}
        College: {college}
        Degree: {degree}
        Year: {year}
        """

        send_mail(subject, message, settings.DEFAULT_FROM_EMAIL, ['test@ieng.tech', 'shila@iengaust.com.au', 'kushankur@iengaust.com.au'])

        return redirect('/thank-you/')
    else:
        return redirect('/')


def sponsor_popup_submit(request):
    if request.method == 'POST':
 
         #Recaptcha
        recaptcha_response = request.POST.get('g-recaptcha-response')
        data = {
            'secret': settings.RECAPTCHA_PRIVATE_KEY,  # Add this in settings.py
            'response': recaptcha_response
        }
        r = requests.post('https://www.google.com/recaptcha/api/siteverify', data=data)
        result = r.json()

        if not result.get('success'):
            messages.error(request, "⚠️ reCAPTCHA verification failed. Please try again.")
            return JsonResponse({'redirect_url': '/thank-you/'})
        
        first_name = request.POST.get('first_name')
        email = request.POST.get('email')
        company_name = request.POST.get('company_name')
        sponsor_type = request.POST.get('sponsor_type')

        subject = "New Sponsorship Interest"
        message = f"""
        Sponsorship Registration:

        First Name: {first_name}
        Company Email: {email}
        Company Name: {company_name}
        Sponsor Type: {sponsor_type}
        """

        send_mail(subject, message, settings.DEFAULT_FROM_EMAIL, ['test@ieng.tech', 'shila@iengaust.com.au', 'kushankur@iengaust.com.au'])

        return redirect('/thank-you/')
    else:
        return redirect('/')
def cmms_demo_submit(request):
    if request.method == 'POST':
        # ✅ Honeypot
        if request.POST.get('company_name'):
            return redirect('/thank-you/')

        # ✅ reCAPTCHA
        recaptcha_response = request.POST.get('g-recaptcha-response')
        data = {
            'secret': settings.RECAPTCHA_PRIVATE_KEY,
            'response': recaptcha_response
        }
        r = requests.post('https://www.google.com/recaptcha/api/siteverify', data=data)
        result = r.json()

        if not result.get('success'):
            messages.error(request, "⚠️ reCAPTCHA verification failed. Please try again.")
            return JsonResponse({'redirect_url': '/thank-you/'})

        # ✅ Extract form fields
        first = request.POST.get('first_name')
        last = request.POST.get('last_name')
        email = request.POST.get('email')
        phone = request.POST.get('phone')
        company = request.POST.get('company')
        country = request.POST.get('country')
        role = request.POST.get('role')
        industry = request.POST.get('industry')
        interest = request.POST.get('interest')

        # ✅ Validate email
        try:
            validate_email(email)
            if is_blocked_email(email):
                messages.error(request, "⚠️ Email domain is not allowed.")
                return redirect('/thank-you/')
        except ValidationError:
            messages.error(request, "⚠️ Invalid email address.")
            return redirect('/thank-you/')

        # ✅ Construct and send email
        message = f"""
        New CARL Demo Booking:

        Name: {first} {last}
        Email: {email}
        Phone: {phone}
        Company: {company}
        Country: {country}
        Role: {role}
        Industry: {industry}
        Interest: {interest}
        """

        send_mail(
            subject="CARL Software Demo Request",
            message=message,
            from_email=settings.DEFAULT_FROM_EMAIL,
            recipient_list=["diksha@iengaust.com.au"],
            fail_silently=False,
        )

        return redirect('/thank-you/')
    else:
        return redirect('/carl-demo/')
    
# country = request.POST.get('country') 
# if country == 'Other':
#     country = request.POST.get('other_country')

def search_suggestions(request):
    query = request.GET.get("q", "").lower()
    if query:
        results = [
            item for item in ITEMS if query in item["name"].lower()
        ]
    else:
        results = []

    return JsonResponse({"results": results})


def home(request):
    return render(request, 'index.html')

def golf(request):
    return render(request, 'golf.html')

def gse(request):
    return render(request, 'gse.html')

def thank_you(request):
    return render(request, 'thank_you.html')

# def thank_you(request):
#     form = ContactForm()
#     return render(request, 'contactFinal.html', {'form': form, 'show_thankyou': True})

def carl_demo(request):
    return render(request, 'carl-demo.html')

def training(request):
    return render(request, 'training.html')

def valves(request):
    return render(request, 'valves.html')


def forms(request):
    return render(request, 'forms.html')

def blog1(request):
    return render(request, 'blog-content1.html')

def blog18(request):
    return render(request, 'blog18.html')

def blog20(request):
    return render(request, 'blog20.html')


def blog19(request):
    return render(request, 'blog19.html')

def blog17(request):
    return render(request, 'blog17.html')

def blog2(request):
    return render(request, 'blogs-content2.html')

def blog3(request):
    return render(request, 'blog-content3.html')

def blog4(request):
    return render(request, 'blog-content4.html')

def blog5(request):
    return render(request, 'blog-content5.html')
def blog7(request):
    return render(request, 'blog7.html')
def blog8(request):
    return render(request, 'blog8.html')
def blog9(request):
    return render(request, 'blog9.html')
def blog15(request):
    return render(request, 'blog15.html')

def blog16(request):
    return render(request, 'blog16.html')
def blog10(request):
    return render(request, 'blog10.html')

def blog13(request):
    return render(request, 'blog13.html')

def blog14(request):
    return render(request, 'blog14.html')

def blog11(request):
    return render(request, 'blog11.html')

def blog12(request):
    return render(request, 'blog12.html')

def blog6(request):
    return render(request, 'blogs-content6.html')

def ac_charger(request):
    return render(request, 'ac-charger.html')

def oil_filteration(request):
    return render(request, 'oil-filteration.html')

def software(request):
    return render(request, 'software.html')

def neplan(request):
    return render(request, 'neplan.html')

def carl_cmms_eam(request):
    return render(request, 'carl-cmms-eam.html')

def healthcare(request):
    return render(request, 'healthcare.html')

def city(request):
    return render(request, 'city.html')

def factory(request):
    return render(request, 'factory.html')

def transport(request):
    return render(request, 'transport.html')

def facility(request):
    return render(request, 'facility.html')

def carl_cloud(request):
    return render(request, 'carl.html')

def carl_flash(request):
    return render(request, 'flash.html')

def carl_express(request):
    return render(request, 'xpress.html')

def ev_charging_station(request):
    return render(request, 'ev-charger.html')

def dc_charging_station(request):
    return render(request, 'dc-charging-station.html')

def emergency_charging_station(request):
    return render(request, 'emergency-mobile-ev-charger.html')

def pantograph_charging_station(request):
    return render(request, 'pantograph-charger.html')

def light(request):
    return render(request, 'light.html')

def lightning(request):
    return render(request, 'lightning-protection.html')

def portable_charging_station(request):
    return render(request, 'portable-charger.html')

def carl_touch(request):
    return render(request, 'touch.html')

def xpress(request):
    return render(request, 'xpress.html')

def xgslab_earthing_emfi_lightning_analysis(request):
    return render(request, 'xgslab.html')

def ems(request):
    return render(request, 'ems.html')

def iot(request):
    return render(request, 'IOT.html')

def powerbi(request):
    return render(request, 'powerbi.html')

def dynamics(request):
    return render(request, 'dynamics.html')

def services(request):
    return render(request, 'services.html')

def asp(request):
    return render(request, 'asp.html')

def power_system_studies(request):
    return render(request, 'power-system-studies-design.html')

def earthing_studies_analysis(request):
    return render(request, 'earthing-studies-analysis.html')

def industrial_engineering(request):
    return render(request, 'industrial-engineering.html')

def maintenance_excellence_cost_saving(request):
    return render(request, 'maintenance-excellence-cost-saving.html')

def renewable_energy(request):
    return render(request, 'renewable-energy.html')

def product3_details(request):
    return render(request, 'product3-details.html')

def electrical_energy_audit(request):
    return render(request, 'electrical-energy-audit.html')

def telecom(request):
    return render(request, 'telecom.html')

def gis(request):
    return render(request, 'gis.html')

def battery(request):
    return render(request, 'battery.html')

def fumigation(request):
    return render(request, 'fumigation.html')

def hv_panel_design(request):
    return render(request, 'hv-panel-design.html')

def hardware(request):
    return render(request, 'hardware.html')

def industrial_supplies_3(request):
    return render(request, 'industrial-supplies.html')

def transmission_line_materials_hardware(request):
    return render(request, 'transmission-line-materials-hardware.html')

def power_cable_acc(request):
    return render(request, 'power-cable-acc.html')

def fiber_cable_acc(request):
    return render(request, 'fiber-cable-acc.html')

def smart_water_management(request):
    return render(request, 'smart-water-management.html')

def energy_mmanagement_system(request):
    return render(request, 'energy-mmanagement-system.html')
def hvismp(request):
    return render(request, 'hvismp.html')
def rpeq(request):
    return render(request, 'rpeq.html')

def bat(request):
    return render(request, 'battery-energy-storage-system-design.html')

def lv_mv_hv(request):
    return render(request, 'lv-mv-hv.html')

def transfoormers(request):
    return render(request, 'transfoormers.html')

def thermal_equipments(request):
    return render(request, 'thermal-equipments.html')

def lv_electrical_power(request):
    return render(request, 'lv-electrical-power.html')

def electrical_motors_bearing(request):
    return render(request, 'electrical-motors-bearing.html')

def earthing_supp(request):
    return render(request, 'earthing-supp.html')

def cable_tray_sys(request):
    return render(request, 'cable-tray-sys.html')

def indoor_outdoor(request):
    return render(request, 'indoor-outdoor.html')

def cable_glands(request):
    return render(request, 'cable-glands.html')

def power_quality_sparesc(request):
    return render(request, 'power-quality-spares.html')

def health_care_eqp(request):
    return render(request, 'health-care-eqp.html')

def miscellaneous_hardware_supplies(request):
    return render(request, 'miscellaneous-hardware-supplies.html')

def industrial_products(request):
    return render(request, 'industrial-products.html')

def ev_charging(request):
    return render(request, 'ev-charging.html')

def generators(request):
    return render(request, 'generators.html')

def lv_electrical_power(request):
    return render(request, 'lv-electrical-power.html')

def hv_panels(request):
    return render(request, 'hv-panels.html')

def solar(request):
    return render(request, 'solar-farm.html')

def power_quality(request):
    return render(request, 'power-quality-analyser.html')

def air_break_switches(request):
    return render(request, 'air-break-switches.html')

def power_quality_solution(request):
    return render(request, 'power-quality-solution.html')

def container_solution(request):
    return render(request, 'container-solution.html')

def junction_box(request):
    return render(request, 'junction-box.html')

def softstarter(request):
    return render(request, 'softstarter.html')

def combiner_box(request):
    return render(request, 'combiner-box.html')

def tool(request):
    return render(request, 'tools&equipment.html')

def fusion(request):
    return render(request, 'fusion-spilcer.html')

def power_analyzer(request):
    return render(request, 'power-quality-analyser.html')

def infrared(request):
    return render(request, 'thermal-imager-infrared-camera.html')

def ac_dc(request):
    return render(request, 'ac-dc-hv-test-set.html')

def ict_product(request):
    return render(request, 'ict-product.html')

def data_center(request):
    return render(request, 'data-center.html')

def fusion_spilcer(request):
    return render(request, 'fusion-spilcer.html')

def plant_Machinery(request):
    return render(request, 'Plants-Machinery.html')

def steel_mill(request):
    return render(request, 'steel-mill.html')

def rice_mill(request):
    return render(request, 'rice-mill.html')

def hydro_power_plant(request):
    return render(request, 'hydro-power-plant.html')

def packaging_plant(request):
    return render(request, 'packaging-plant.html')

def color_sorting_machine(request):
    return render(request, 'color-sorting-machine.html')

def about(request):
    return render(request, 'about.html')

def ismart(request):
    return render(request, 'ismart.html')

def insight(request):
    return render(request, 'insights.html')

def blog21(request):
    return render(request, 'blog21.html')
def blog22(request):
    return render(request, 'blog22.html')

def blog23(request):
    return render(request, 'blog23.html')

def blog24(request):
    return render(request, 'blog24.html')

# def contact(request):
#     if request.method == 'POST':
#         form = ContactForm(request.POST)
#         if form.is_valid():
#             # Extract cleaned data
#             first_name = form.cleaned_data['first_name']
#             last_name = form.cleaned_data['last_name']
#             looking_for = ', '.join(form.cleaned_data.get('looking_for', []))
#             email = form.cleaned_data['email']
#             other_product = form.cleaned_data.get('other_product', '')
#             mobile = form.cleaned_data['mobile']
#             message = form.cleaned_data['message']

#             # Save to database (optional)
#             Contact.objects.create(
#                 first_name=first_name,
#                 last_name=last_name,
#                 looking_for=looking_for,
#                 email=email,
#                 other_product=other_product,
#                 mobile=mobile,
#                 message=message
#             )

#             # Send email notification (optional)
#             subject = f"New Contact Form Submission from {first_name} {last_name}"
#             email_message = f"""
#             You have a new contact form submission:

#             First Name: {first_name}
#             Last Name: {last_name}
#             Looking For: {looking_for}
#             Email: {email}
#             Other Product: {other_product}
#             Mobile: {mobile}
#             Message:
#             {message}
#             """
#             send_mail(
#                 subject,
#                 email_message,
#                 settings.DEFAULT_FROM_EMAIL,
#                 [settings.CONTACT_EMAIL],  # Replace with your admin email
#                 fail_silently=False,
#             )

#             messages.success(request, 'Your message has been sent successfully!')
#             return redirect('contact')
#         else:
#             messages.error(request, 'Please correct the errors below.')
#     else:
#         form = ContactForm()

#     return render(request, 'contactFinal.html', {'form': form})
from django.shortcuts import render, redirect
from django.core.mail import send_mail
from django.conf import settings
from django.contrib import messages
from .forms import ContactForm

def contact(request):
    if request.method == 'POST':
        form = ContactForm(request.POST)

        #Recaptcha
        recaptcha_response = request.POST.get('g-recaptcha-response')
        data = {
            'secret': settings.RECAPTCHA_PRIVATE_KEY,  # Add this in settings.py
            'response': recaptcha_response
        }
        r = requests.post('https://www.google.com/recaptcha/api/siteverify', data=data)
        result = r.json()

        if not result.get('success'):
            messages.error(request, "⚠️ reCAPTCHA verification failed. Please try again.")
            return render(request, 'contactFinal.html', {'form': form})


        if form.is_valid():
            # Extract form data
            first_name = form.cleaned_data['first_name']
            looking_for = form.cleaned_data['looking_for']
            email = form.cleaned_data['email']
            country_code = form.cleaned_data['country_code']
            mobile_number = form.cleaned_data['mobile_number']
            message = form.cleaned_data['message']

            # Compose email
            subject = f"New Contact Form Submission from {first_name}"
            message_body = f"""
            Full Name: {first_name}
            Looking For: {looking_for}
            Email: {email}
            Country Code: {country_code}
            Mobile Number: {mobile_number}
            Message: {message}
            """

            # Send email
            send_mail(
                subject,
                message_body,
                settings.DEFAULT_FROM_EMAIL,
                ['test@ieng.tech', 'shila@iengaust.com.au','diksha@iengaust.com.au','mayur@iengaust.co.au'],
            )

            # messages.success(request, "Thank you for contacting us! We’ll be in touch shortly.")
            return redirect('/thank-you/')
        else:
            messages.error(request, "Please correct the errors below and try again.")
    else:
        form = ContactForm()

    return render(request, 'contactFinal.html', {'form': form})






def career(request):
    return render(request, 'careers.html')

def blog(request):
    return render(request, 'blogs.html')

def control(request):
    return render(request, 'control-automation.html')

def plc(request):
    return render(request, 'plc.html')

def iotsup(request):
    return render(request, 'iotsupplies.html')

def vsd(request):
    return render(request, 'vsd.html')

def hmi(request):
    return render(request, 'hmi.html')

def project_manage(request):
    return render(request, 'project-manage.html')

def boiler(request):
    return render(request, 'boiler.html')

def dcs(request):
    return render(request, 'dsc.html')

def scada(request):
    return render(request, 'scada.html')

def error(request):
    return render(request, 'error.html')

def privacy(request):
    return render(request, 'privacy-policy.html')

def Control(request):
    return render(request, 'privacy-policy.html')

def sitemap(request):
    with staticfiles_storage.open('sitemap.xml') as sitemap_file:
        return HttpResponse(sitemap_file, content_type='application/xml')

# def contact_view(request):
#     if request.method == "POST":
#         form = ContactForm(request.POST)
#         if form.is_valid():
#             # Process form data
#             first_name = form.cleaned_data['first_name']
#             last_name = form.cleaned_data['last_name']
#             email = form.cleaned_data['email']
#             mobile = form.cleaned_data['mobile']
#             looking_for = form.cleaned_data['looking_for']
#             other_product = form.cleaned_data['other_product']
#             message = form.cleaned_data['message']

#             # Log data or send an email (for example)
#             print(f"Form Submitted by {first_name} {last_name}: {email}, {mobile}, {looking_for}, {message}")

#             # Show a success message
#             messages.success(request, "Your message has been submitted successfully!")
#             return redirect('contact')  # Redirect to the same page or another page

#     else:
#         form = ContactForm()

#     return render(request, 'contactFinal.html', {'form': form})

# def submit_form(request):
#     if request.method == 'POST':
#         data = request.POST
#         # Process the form data here
#         return JsonResponse({'message': 'Form submitted successfully', 'data': data})
