document.addEventListener("DOMContentLoaded", () => {
  const menuIcon = document.querySelector(".bx-menu");
  const navLinks = document.querySelector(".nav-links");

  menuIcon.addEventListener("click", () => {
    navLinks.classList.toggle("active");
  });

  // Close menu when clicking outside (optional)
  document.addEventListener("click", (e) => {
    if (!menuIcon.contains(e.target) && !navLinks.contains(e.target)) {
      navLinks.classList.remove("active");
    }
  });

  // Search-box open-close functionality
  const navbar = document.querySelector(".navbar");
  const searchBox = document.querySelector(".search-box .bx-search");

  searchBox.addEventListener("click", () => {
    navbar.classList.toggle("showInput");
    if (navbar.classList.contains("showInput")) {
      searchBox.classList.replace("bx-search", "bx-x");
    } else {
      searchBox.classList.replace("bx-x", "bx-search");
    }
  });

  // Sidebar submenu functionality
  const menuCloseBtn = document.querySelector(".nav-links .bx-x");
  const htmlcssArrow = document.querySelector(".htmlcss-arrow");
  const inArrow = document.querySelector(".in-arrow");
  const moreArrow = document.querySelector(".more-arrow");
  const more1Arrow = document.querySelector(".more1-arrow");
  const more2Arrow = document.querySelector(".more2-arrow");
  const more3Arrow = document.querySelector(".more3-arrow");
  const more4Arrow = document.querySelector(".more4-arrow");
  const jsArrow = document.querySelector(".js-arrow");
  const js1Arrow = document.querySelector(".js1-arrow");

  menuIcon.onclick = function () {
    navLinks.style.left = "0";
  };

  menuCloseBtn.onclick = function () {
    navLinks.style.left = "-100%";
  };

  htmlcssArrow.onclick = function () {
    navLinks.classList.toggle("show1");
  };
  inArrow.onclick = function () {
    navLinks.classList.toggle("show6");
  };

  moreArrow.onclick = function () {
    navLinks.classList.toggle("show2");
  };
  more1Arrow.onclick = function () {
    navLinks.classList.toggle("show7");
  };

  more2Arrow.onclick = function () {
    navLinks.classList.toggle("show8");
  };

  more3Arrow.onclick = function () {
    navLinks.classList.toggle("show9");
  };
  more4Arrow.onclick = function () {
    navLinks.classList.toggle("show10");
  };



  jsArrow.onclick = function () {
    navLinks.classList.toggle("show3");
  };

  js1Arrow.onclick = function () {
    navLinks.classList.toggle("show4");
  };
});
