$(document).ready(function () {
    // Toggle navbar on hamburger click
    $('.fa-bars').click(function () {
        $(this).toggleClass('fa-times');
        $('.navbar').toggleClass('nav-toggle');
    });

    // // Navbar and header behavior on scroll
    // $(window).on('load scroll', function () {
    //     $('.fa-bars').removeClass('fa-times');
    //     $('.navbar').removeClass('nav-toggle');

    //     if ($(window).scrollTop() > 35) {
    //         $('.header').css({ 'background': '#002e5f', 'box-shadow': '0 .2rem .5rem rgba(0,0,0,.4)' });
    //     } else {
    //         $('.header').css({ 'background': 'none', 'box-shadow': 'none' });
    //     }
    // });

    // Counter animation
    const counters = document.querySelectorAll('.counter');
    const speed = 120;
    counters.forEach(counter => {
        const updateCount = () => {
            const target = +counter.getAttribute('data-target');
            const count = +counter.innerText;
            const inc = target / speed;
            if (count < target) {
                counter.innerText = Math.ceil(count + inc);
                setTimeout(updateCount, 1);
            } else {
                counter.innerText = target;
            }
        };
        updateCount();
    });

    // Owl Carousel for clients and testimonials
    (function ($) {
        "use strict";

        $(".clients-carousel").owlCarousel({
            autoplay: true,
            dots: true,
            loop: true,
            responsive: { 0: { items: 2 }, 768: { items: 4 }, 900: { items: 6 } }
        });

        $(".testimonials-carousel").owlCarousel({
            autoplay: true,
            dots: true,
            loop: true,
            responsive: { 0: { items: 1 }, 576: { items: 2 }, 768: { items: 3 }, 992: { items: 4 } }
        });

    })(jQuery);

    // Back to top button functionality
    $(window).scroll(function () {
        if ($(this).scrollTop() > 100) {
            $('.back-to-top').fadeIn('slow');
        } else {
            $('.back-to-top').fadeOut('slow');
        }
    });

    $('.back-to-top').click(function () {
        $('html, body').animate({ scrollTop: 0 }, 1500, 'easeInOutExpo');
        return false;
    });

    // Accordion functionality
    $('.accordion-header').click(function () {
        $('.accordion .accordion-body').slideUp(500);
        $(this).next('.accordion-body').slideDown(500);
        $('.accordion .accordion-header span').text('+');
        $(this).children('span').text('-');
    });

    // Form validation
    window.validateForm = function () {
        var firstName = document.forms["contactForm"]["firstName"].value;
        var lastName = document.forms["contactForm"]["lastName"].value;
        var email = document.forms["contactForm"]["email"].value;
        var mobileNumber = document.forms["contactForm"]["mobileNumber"].value;
        var message = document.forms["contactForm"]["message"].value;

        if (firstName === "" || lastName === "" || email === "" || mobileNumber === "" || message === "") {
            alert("Please fill out all the fields before submitting the form.");
            return false;
        }
        return true;
    };
});

document.addEventListener("DOMContentLoaded", function () {
    const reveals = document.querySelectorAll(".reveal");

    const observer = new IntersectionObserver((entries) => {
        entries.forEach((entry) => {
            if (entry.isIntersecting) {
                entry.target.classList.add("visible");
            } else {
                entry.target.classList.remove("visible");
            }
        });
    }, {
        threshold: 0.1
    });

    reveals.forEach((el) => observer.observe(el));
});
