let currentIndex = 0;
const cards = document.querySelectorAll('.product-card1');
const totalCards = cards.length;

const updateCarousel = () => {
  const container = document.querySelector('.product-card1-container');
  container.style.transform = `translateX(-${currentIndex * (cards[0].offsetWidth + 30)}px)`;
};

document.querySelector('.right-btn').addEventListener('click', () => {
  if (currentIndex < totalCards - 3) {
    currentIndex++;
  } else {
    currentIndex = 0;
  }
  updateCarousel();
});

document.querySelector('.left-btn').addEventListener('click', () => {
  if (currentIndex > 0) {
    currentIndex--;
  } else {
    currentIndex = totalCards - 3;
  }
  updateCarousel();
});

window.addEventListener('resize', updateCarousel);
