// Attach event listener to the search input
document.addEventListener("DOMContentLoaded", () => {
    const searchInput = document.getElementById("searchInput");
    const suggestionBox = document.getElementById("suggestionBox");
  
    searchInput.addEventListener("input", function () {
      const query = searchInput.value.trim().toLowerCase();
  
      // Clear previous suggestions
      suggestionBox.innerHTML = "";
  
      if (query.length >= 3) {
        // Fetch suggestions from Django backend
        fetch(`/search-suggestions/?q=${encodeURIComponent(query)}`)
          .then(response => {
            if (!response.ok) {
              throw new Error("Network response was not ok");
            }
            return response.json();
          })
          .then(data => {
            if (data.results && data.results.length > 0) {
              data.results.forEach(item => {
                const li = document.createElement("li");
                li.textContent = item.name;
                li.onclick = () => {
                  window.location.href = item.url; // Navigate to the item's URL
                };
                suggestionBox.appendChild(li);
              });
            } else {
              const li = document.createElement("li");
              li.textContent = "No results found";
              suggestionBox.appendChild(li);
            }
          })
          .catch(error => {
            console.error("Error fetching suggestions:", error);
          });
      }
    });
  });
  