const cardWrapper = document.getElementById('cardWrapper');
const cards = document.querySelectorAll('.home-scroll-cardh-card');
const cardWidth = 320; // Width of each card including margin
let currentIndex = 0; // Track the index of the first visible card

// Scroll left
function scrollLeft() {
  if (currentIndex > 0) {
    currentIndex--; // Move to the previous card
    const offset = currentIndex * cardWidth;
    cardWrapper.style.transform = `translateX(-${offset}px)`;
  }
}

// Scroll right
function scrollRight() {
  const totalCards = cards.length;
  if (currentIndex < totalCards - 3) { // Prevent scrolling beyond the last visible set of cards
    currentIndex++; // Move to the next card
    const offset = currentIndex * cardWidth;
    cardWrapper.style.transform = `translateX(-${offset}px)`;
  }
}
