// Scroll Animation for Feature Items
document.addEventListener("DOMContentLoaded", function () {
    
    const scrollElements = document.querySelectorAll("[data-scroll]");

    const elementInView = (el, percentageScroll = 100) => {
        const elementTop = el.getBoundingClientRect().top;
        return (
            elementTop <=
            (window.innerHeight || document.documentElement.clientHeight) * (percentageScroll / 100)
        );
    };

    const displayScrollElement = (element) => {
        element.classList.add("visible");
    };

    const hideScrollElement = (element) => {
        element.classList.remove("visible");
    };

    const handleScrollAnimation = () => {
        scrollElements.forEach((el) => {
            if (elementInView(el, 100)) {
                displayScrollElement(el);
            } else {
                hideScrollElement(el);
            }
        });
    };

    window.addEventListener("scroll", () => {
        handleScrollAnimation();
    });
    handleScrollAnimation();

    // Slideshow Initialization
    showSlides();
});

// Slideshow Logic
let slideIndex = 0;

// Function to show the current slide
function showSlides() {
    const slides = document.querySelectorAll(".xgs-slideshow img");
    
    // Hide all slides
    slides.forEach(slide => slide.classList.remove('active'));

    // Increment slide index
    slideIndex++;

    // Loop back to the first slide if index exceeds the number of slides
    if (slideIndex > slides.length) { slideIndex = 1; }

    // Show the current slide
    slides[slideIndex - 1].classList.add('active');

    // Change slide every 2 seconds
    setTimeout(showSlides, 2000);
}
