// Smooth scroll to link section (if more content is added in the future)
document.querySelectorAll('.fiber-cable-acc-link').forEach(link => {
    link.addEventListener('click', function (e) {
      e.preventDefault();
      const targetId = this.getAttribute('href');
      const targetElement = document.querySelector(targetId);
      if (targetElement) {
        window.scrollTo({
          top: targetElement.offsetTop,
          behavior: 'smooth'
        });
      }
    });
  });
  
  // JavaScript to trigger animations when scrolling into view
document.addEventListener("DOMContentLoaded", function() {
    const points = document.querySelectorAll('.fiber-cable-acc-points-list .fiber-cable-acc-points-point');
    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('active');
                observer.unobserve(entry.target);
            }
        });
    }, {
        threshold: 0.5
    });

    points.forEach(point => {
        observer.observe(point);
    });
});
