
const data = [
  {
    imageUrl: "/static/images/testimonials/abram.png",
    review: "The iEngineering Team is highly professional and detail-oriented, renowned for their meticulous precision. They delivered our project on time, exceeding expectations in design and service quality. From initial design to final implementation, every aspect was executed with exceptional care, accuracy, and dedication to excellence.",
    name: "Abraham Aremwa",
    designation: "Chairman, Nauru Utilities Corporation",
  },
  {
    imageUrl: "/static/images/testimonials/kunal.png",
    review: "The iEngineering team transformed our asset management using CARL Software. Their expertise enabled real-time tracking, streamlined workflows, and improved efficiency. Their commitment to delivering advanced solutions has greatly enhanced our operations, driving success and boosting overall productivity across departments.",
    name: "Kunal Deo",
    designation: "Maintenance Manager, Fiji Ports Corporation Limited",
  },
  {
    imageUrl: "/static/images/testimonials/charlie.png",
    review: "Working with iEngineering was a pleasure. Their team displayed professionalism and dedication, delivering our project on time with exceptional quality. From consultation to implementation, they ensured clear communication and attention to detail. The outcome exceeded expectations, showcasing their precision and expertise.",
    name: "Charlie Micallef",
    designation: "Project Manager, WestRock Australia",
  },
  {
    imageUrl: "/static/images/testimonials/ashit.png",
    review: "iEngineering has been a reliable partner across our projects. They understood our technical needs, delivered on time, and maintained clear communication throughout. Their attention to detail and professionalism made the process smooth. We value their support and look forward to working with them again.",
    name: "Ashit Patel",
    designation: "Engineering Manager, FMF Group",
  },
  {
    imageUrl: "/static/images/testimonials/john.png",
    review: "Collaborating with iEngineering was a smart choice for our business. Their commitment to excellence and understanding of our needs ensured a smooth experience. With strong focus on quality, timeliness, and customer satisfaction, they made a lasting impact on our overall success. ",
    name: "John Walcott",
    designation: "Director, Walcott Engineering",
  },
  {
    imageUrl: "/static/images/testimonials/timoci.png",
    review: "iEngineering is our one-stop solution for engineering and project needs. Their blend of advanced technology and practical solutions has transformed operations. With innovation and a customer-first approach, they consistently drive efficiency and success, making them an invaluable and trusted partner. ",
    name: "Timoci Naulumatu",
    designation: "General Manager, Trukai Industries Limited",
  },
];

const showMoreBtn = document.querySelector(".testimonials-container .show-more-btn");
const testimonials = document.querySelector(".testimonials");
let latestTestimonialIndex = 0;
let isExpanded = false;

const generateTestimonial = (imageUrl, review, name, designation) => {
  return `
    <div class="testimonial">
      <div class="image">
        <img src="${imageUrl}" alt="${name}" width="100%" />
      </div>
      <div class="review">${review}</div>
      <div class="bottom">
        <div class="name">${name}</div>
        <div class="designation">${designation}</div>
      </div>
    </div>`;
};

const showTestimonials = (count) => {
  testimonials.innerHTML = "";
  for (let i = 0; i < count && i < data.length; i++) {
    testimonials.innerHTML += generateTestimonial(
      data[i].imageUrl,
      data[i].review,
      data[i].name,
      data[i].designation
    );
  }
};

showTestimonials(3);

showMoreBtn.addEventListener("click", () => {
  if (!isExpanded) {
    showTestimonials(data.length);
    showMoreBtn.textContent = "Show less...";
    isExpanded = true;
  } else {
    showTestimonials(3);
    showMoreBtn.textContent = "Show more...";
    isExpanded = false;
  }
});



