document.addEventListener("DOMContentLoaded", function() {
    // Get all sections that should become visible
    const sections = document.querySelectorAll(".transmission-line-material-section-container2");

    // Function to check if the section is in view
    function isInViewport(element) {
        const rect = element.getBoundingClientRect();
        return rect.top <= window.innerHeight && rect.bottom >= 0;
    }

    // Function to handle scroll
    function handleScroll() {
        sections.forEach(section => {
            if (isInViewport(section)) {
                section.classList.add("visible");
            }
        });
    }

    // Event listeners
    window.addEventListener("scroll", handleScroll);
    window.addEventListener("resize", handleScroll);

    // Initial check to see if sections are in view
    handleScroll();
});
function goToMoreInfo(section) {
    window.location.href = `#${section}`;
}

// Scroll detection to hide/show the transmission-line-material-box-block
let lastScrollTop = 0;
const healthBoxBlock = document.querySelector('.transmission-line-material-box-block');

window.addEventListener('scroll', () => {
    let currentScrollTop = window.pageYOffset || document.documentElement.scrollTop;
    if (currentScrollTop > lastScrollTop) {
        // Scrolling down
        healthBoxBlock.classList.add('hidden');
    } else {
        // Scrolling up
        healthBoxBlock.classList.remove('hidden');
    }
    lastScrollTop = currentScrollTop <= 0 ? 0 : currentScrollTop; // Prevent negative scroll
});