const boxes = document.querySelectorAll(".box");

const checkBoxes = () => {
  const triggerBottom = (window.innerHeight / 5) * 4;
  boxes.forEach((box) => {
    const boxTop = box.getBoundingClientRect().top;
    if (boxTop < triggerBottom) {
      box.classList.add("show"); // Add 'show' class when the box is in view
    } else {
      box.classList.remove("show"); // Remove 'show' when the box is out of view
    }
  });
};

window.addEventListener("scroll", checkBoxes);
checkBoxes(); // Trigger on page load as well
